import os

from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_vault_item


class CryptaStatsExporterBundle(sdk2.Resource):

    releasable = True


class CryptaStatsExporter(CryptaTask):

    """ Export metrics from grafit and statface and import into crypta matching base metrics """

    class CryptaOptions(CryptaTask.CryptaOptions):

        bundle_resource_type = CryptaStatsExporterBundle
        use_semaphore = False

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace('stable', 'production').upper()
        stat_token = get_vault_item("sec-01daxg3xp40d5pr2s52sb22pkm[secret]")
        return {'ENV_TYPE': env_type, 'STAT_TOKEN': stat_token, 'YT_PROXY': 'hahn.yt.yandex.net', }

    def get_cmd(self):
        return [os.path.abspath('stats-exporter')]
