import os

import sandbox.common.types.misc as ctm
from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_vault_item


class CryptaStatsTelegramNotifyBundle(sdk2.Resource):

    releasable = True


class CryptaWkhtmlBundle(sdk2.Resource):

    releasable = True


class CryptaStatsTelegramNotify(CryptaTask):
    class Requirements(CryptaTask.Requirements):
        dns = ctm.DnsType.DNS64

    class CryptaOptions(CryptaTask.CryptaOptions):

        bundle_resource_type = CryptaStatsTelegramNotifyBundle
        use_semaphore = False

    class Parameters(CryptaTask.Parameters):

        pass

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace("stable", "production").upper()
        telegram_token = get_vault_item("sec-01csvzsvvkpg76qq8hqfga4s4a[tg_token]")
        telegram_chat_ids = get_vault_item("sec-01csvzsvvkpg76qq8hqfga4s4a[tg_chat_ids]")
        slack_token = get_vault_item("sec-01csvzsvvkpg76qq8hqfga4s4a[slack_token]")
        slack_chat_ids = get_vault_item("sec-01csvzsvvkpg76qq8hqfga4s4a[slack_chat_ids]")
        tvm_id = "2027912"
        tvm_secret = get_vault_item("sec-01f4cjs5tkpgxhk0w7kzqp0151[client_secret]")
        return {
            "ENV_TYPE": env_type,
            "YT_PROXY": "hahn.yt.yandex.net",
            "TELEGRAM_TOKEN": telegram_token,
            "TELEGRAM_CHAT_IDS": telegram_chat_ids,
            "SLACK_TOKEN": slack_token,
            "SLACK_CHAT_IDS": slack_chat_ids,
            "TVM_ID": tvm_id,
            "TVM_SECRET": tvm_secret
        }

    def get_cmd(self):
        cmd = [os.path.abspath("telegram")]
        return cmd
