import datetime
import os

from sandbox import sdk2
from sandbox.projects.crypta.common.task import CryptaTask


class CryptaUserParamsMetricsBundle(sdk2.Resource):

    releasable = True


class CryptaUserParamsMetrics(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):

        bundle_resource_type = CryptaUserParamsMetricsBundle
        use_semaphore = False
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):

        date = sdk2.parameters.String(
            'Date for metrics calc',
            required=False
        )
        approved_domens_table = sdk2.parameters.String(
            'YT path to approved domens',
            required=False,
            default='//home/crypta/production/graph/config/wl_client_user_id/approved_domens'
        )
        soup_cooked_edges = sdk2.parameters.String(
            'YT path to soup cooked edges',
            required=False,
            default='//home/crypta/production/state/graph/v2/soup/cooked/soup_edges'
        )
        output_dir = sdk2.parameters.String(
            'YT path to directory where will be stored metrics',
            required=True
        )

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace('stable', 'production').upper()
        return {
            'ENV_TYPE': env_type,
            'ENVIRONMENT': env_type.lower(),
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_POOL': 'crypta_graph'
        }

    def get_cmd(self):
        return [
            os.path.abspath('user-params-metrics'),
            '--date', self.Parameters.date or (
                datetime.date.today() - datetime.timedelta(days=1)).strftime('%Y-%m-%d'),
            '--approved-domens-table', self.Parameters.approved_domens_table,
            '--soup-cooked-edges', self.Parameters.soup_cooked_edges,
            '--output-dir', self.Parameters.output_dir,
        ]
