from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_vault_item

import os
import datetime


class CryptaGraphProbabilisticBundle(sdk2.Resource):
    releasable = True


class CryptaGraphProbabilistic(CryptaTask):
    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphProbabilisticBundle
        graphite_monitoring_task_name = "crypta-graph-probabilistic"
        use_semaphore = False

    class Parameters(CryptaTask.Parameters):
        with sdk2.parameters.Group("Task") as task:
            task_name = sdk2.parameters.String("Task name")
            task_args = sdk2.parameters.Dict("Task parameters")
        with sdk2.parameters.Group("Environment parameters") as vault:
            STATS_TOKEN = sdk2.parameters.String("Statface Token")

    @staticmethod
    def wrap_special(value):
        if value == "yesterday":
            today = datetime.date.today()
            yesterday = today - datetime.timedelta(days=1)
            return yesterday.isoformat()
        return value

    def task_parameters(self):
        for (key, value) in (self.Parameters.task_args or {}).items():
            yield "--" + key
            yield self.wrap_special(value)

    def get_additional_env(self):
        env_type = self.Parameters.environment
        normalized_env_type = env_type.replace("stable", "production").upper()
        stats_token = get_vault_item("sec-01daxg3xp40d5pr2s52sb22pkm[secret]")
        return {"STATS_TOKEN": stats_token, "ENV_TYPE": normalized_env_type}

    def get_cmd(self):
        return [os.path.abspath("fuzzy"), "--local", self.Parameters.task_name] + list(self.task_parameters())
