from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import get_vault_item

import os


class CryptaGraphRtdiBundle(sdk2.Resource):
    releasable = True


class CryptaGraphRtdi(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphRtdiBundle
        use_semaphore = False

    class Parameters(CryptaTask.Parameters):
        with sdk2.parameters.Group("Vault"):
            METRIKA_PRIVATE_KEY = sdk2.parameters.String("Name of metrika private key secret", required=True)

    def get_additional_env(self):
        return {
            'YT_PROXY': "hahn.yt.yandex.net",
            'METRIKA_PRIVATE_KEY': get_vault_item(self.Parameters.METRIKA_PRIVATE_KEY)
        }

    def get_cmd(self):
        cmd = [
            os.path.abspath("rtdi"),
        ]
        return cmd
