from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask

import os


class CryptaGraphSoupComponentsBundle(sdk2.Resource):
    releasable = True


class CryptaGraphSoupComponents(CryptaTask):
    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphSoupComponentsBundle
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):
        pool = sdk2.parameters.String("YT pool", default_value='crypta_graph')

    def get_additional_env(self):
        return {
            'YT_POOL': self.Parameters.pool,
        }

    def get_cmd(self):
        result = [
            os.path.abspath("soup_components")
        ]
        return result
