from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask

import os


class CryptaGraphSoupEdgeWeightsHistogramsBundle(sdk2.Resource):
    releasable = True


class CryptaGraphSoupEdgeWeightsHistograms(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphSoupEdgeWeightsHistogramsBundle

    class Parameters(CryptaTask.Parameters):
        pool = sdk2.parameters.String("YT pool", default_value='crypta_graph')
        source_dir = sdk2.parameters.String(
            "Directory with soup tables",
            default_value='//home/crypta/production/state/graph/v2/soup/cooked/soup_edges')
        destination_path = sdk2.parameters.String(
            "Destination",
            default_value='//home/crypta/production/state/graph/v2/soup/cooked/stats/NewHistogramEdges')

    def get_additional_env(self):
        return {
            'ENVIRONMENT': self.Parameters.environment.replace('stable', 'production'),
            'YT_POOL': self.Parameters.pool,
        }

    def get_cmd(self):
        result = [
            os.path.abspath("edge_weights"),
            "-s", str(self.Parameters.source_dir),
            "-d", str(self.Parameters.destination_path)
        ]
        return result
