import datetime
import os

from sandbox import sdk2
from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.graph.matching import get_matching_env


class CryptaGraphPrepareSoupDynamicBuild(sdk2.Resource):
    releasable = True


class CryptaGraphPrepareSoupDynamicYaml(CryptaTask):
    class Requirements(CryptaTask.Requirements):
        environments = [SandboxJavaJdkEnvironment('17.0.2')]

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphPrepareSoupDynamicBuild
        templates = ["config.yaml"]
        graphite_monitoring_task_name = "crypta-graph-prepare-soup-dynamic"
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):
        kill_timeout = 60 * 60 * 12
        soupGenerationDate = sdk2.parameters.String("Soup generation date",
                                                    required=True,
                                                    default=str(datetime.date.today()))

    def get_cmd(self):
        return [
            os.path.abspath("run.sh"),
            "--config", 'config.yaml'
        ]

    def get_additional_env(self):
        return get_matching_env(self.Parameters.environment)
