import datetime
import os

from sandbox import sdk2
from sandbox.projects.crypta.common.task import CryptaTask


def wrap_date(value):
    if value == 'yesterday':
        today = datetime.date.today()
        yesterday = today - datetime.timedelta(days=1)
        return yesterday.isoformat()
    elif value == 'ereyesterday':
        today = datetime.date.today()
        ereyesterday = today - datetime.timedelta(days=2)
        return ereyesterday.isoformat()
    return value


class CryptaGraphPrepareRadiusSoupBuild(sdk2.Resource):
    releasable = True


class CryptaGraphPrepareRadiusSoup(CryptaTask):
    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphPrepareRadiusSoupBuild

        graphite_monitoring_task_name = "crypta-graph-prepare-radius-soup"

    class Parameters(CryptaTask.Parameters):
        date = sdk2.parameters.String("Date", required=True, default='yesterday')

    def get_cmd(self):
        return [
            os.path.abspath("radius_soup"),
            "--mrjob", os.path.abspath("mrjob"),
            "--udfr", os.path.abspath("udf_resolver"),
            "--udfsdir", os.path.abspath("udfs"),
            wrap_date(self.Parameters.date)
        ]
