import os
import logging

from sandbox import sdk2
from sandbox.projects.crypta.common.task import CryptaTask


RANDOM_MODE = "random"
STAFF_MODE = "staff"

logger = logging.getLogger(__name__)


class CryptaGraphSampleSoupBuild(sdk2.Resource):
    releasable = True


class CryptaGraphSampleSoup(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphSampleSoupBuild
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):
        kill_timeout = 60 * 60 * 4
        mode = sdk2.parameters.String("Mode of sample", choices=[(RANDOM_MODE, RANDOM_MODE), (STAFF_MODE, STAFF_MODE)], default=RANDOM_MODE)

        with mode.value[RANDOM_MODE]:
            percent = sdk2.parameters.Float("Percent of random components in sample, e.g. 10% is 0.1", default=0.1, required=False)

        components_table = sdk2.parameters.String("YT path to all components table")
        output_edges_table = sdk2.parameters.String("YT path to output soup edges table")
        output_properties_table = sdk2.parameters.String("YT path to output soup vertices properties table")
        yt_proxy = sdk2.parameters.String("YT proxy", default_value="hahn.yt.yandex.net")
        yt_pool = sdk2.parameters.String("YT pool", default_value="crypta")

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace("stable", "production").upper()

        return {"ENV_TYPE": env_type}

    def get_cmd(self):
        mode = self.Parameters.mode

        command = [
            os.path.abspath("crypta_graph_sampling"),
            "--mode", mode,
            "--components_table", self.Parameters.components_table,
            "--output-edges", self.Parameters.output_edges_table,
            "--output-properties", self.Parameters.output_properties_table,
            "--yt-proxy", self.Parameters.yt_proxy,
            "--yt-pool", self.Parameters.yt_pool,
        ]

        if mode == RANDOM_MODE:
            command.extend(["--percent", str(self.Parameters.percent)])

        return command

    def get_crypta_api_params(self):
        return {
            "mode": self.Parameters.mode
        }
