from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaBaseYqlTask
from sandbox.projects.crypta.common.vault import get_vault_item


class CryptaStaffExporterBundle(sdk2.Resource):

    releasable = True


class CryptaStaffExporter(CryptaBaseYqlTask):

    TASK = "crypta.graph.staff.lib.StaffTask"
    BIN_FILE_NAME = "staff-exporter"

    class CryptaOptions(CryptaBaseYqlTask.CryptaOptions):

        bundle_resource_type = CryptaStaffExporterBundle
        use_semaphore = True
        report_status_to_crypta_api = True

    def get_additional_env(self, *args, **kwargs):
        env = super(CryptaStaffExporter, self).get_additional_env(*args, **kwargs)
        env.update(
            {
                "ENV_TYPE": self.Parameters.environment.replace("stable", "production").upper(),
                "STAFF_EXPORTER_TOKEN": get_vault_item("sec-01csvzg8w8tz3ksctnn7h9ew0e[oauth]"),
            }
        )
        return env
