# -*- coding: utf-8 -*-
import os

from sandbox import sdk2
from sandbox.projects.crypta.common import helpers, vault, task


kHOUR = 60 * 60  # seconds in hour


class CryptaGraphStyxExpandBundle(sdk2.Resource):
    releasable = True


class CryptaGraphStyxExpand(task.CryptaTask):
    """Run graph styx expander"""

    class CryptaOptions(task.CryptaTask.CryptaOptions):

        bundle_resource_type = CryptaGraphStyxExpandBundle
        use_semaphore = True
        report_status_to_crypta_api = True

    class Parameters(task.CryptaTask.Parameters):

        kill_timeout = int(kHOUR)
        tags = ["styx"]

        pool = sdk2.parameters.String("YT pool", required=False)
        task = sdk2.parameters.String("Task", required=True, default="crypta.graph.styx.lib.tasks.StyxExpandTask")
        options = sdk2.parameters.Dict("Additional params for run binary", required=False)
        extra_args = sdk2.parameters.Dict(
            "Additional args for bt task (will be added to cmd as [--arg, key=value])", required=False
        )

    def get_cmd(self):
        cmd = [os.path.abspath("styx-expand")]

        for key, value in self.Parameters.options.items():
            cmd.extend([key, value] if value else [key])
        else:
            cmd.extend(["--config", os.path.abspath("styx_expand.pb.txt")])

        cmd.extend(["run", "--task", self.Parameters.task])

        for key, value in self.Parameters.extra_args.items():
            cmd.extend(["--arg", "{key}={value}".format(key=key, value=value)])

        return cmd

    def get_additional_env(self):
        env_type = self.Parameters.environment
        return {
            "YT_POOL": self.yt_pool,
            "CRYPTA_ENVIRONMENT": env_type.replace("stable", "production"),
            "YT_TOKEN": vault.get_yt_token("stable"),
            "YQL_TOKEN": vault.get_yql_token("stable"),
        }

    @property
    def yt_pool(self):
        if self.Parameters.pool:
            return self.Parameters.pool
        return {helpers.STABLE: "crypta_graph", helpers.TESTING: "crypta_graph_testing"}[self.Parameters.environment]
