import os

from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import (
    get_statface_token,
    get_crypta_api_token,
)


class CryptaGraphTaskRunnerBundle(sdk2.Resource):
    releasable = True


class CryptaGraphTaskRunner(CryptaTask):
    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaGraphTaskRunnerBundle
        graphite_monitoring_task_name = "crypta-graph-task-runner"
        use_semaphore = False
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):
        kill_timeout = 60 * 60 * 30  # 30 hours

        task_name = sdk2.parameters.String("Task name")
        is_experiment = sdk2.parameters.Bool("Experiment", default=False)
        task_args = sdk2.parameters.Dict("Task parameters")

    def task_parameters(self):
        for (key, value) in (self.Parameters.task_args or {}).items():
            yield key
            yield "="
            yield value

    def get_additional_env(self):
        env = {
            "CRYPTA_ENVIRONMENT": self.Parameters.environment.replace("stable", "production"),
            "STATFACE_TOKEN": get_statface_token(),
            "OAUTH_TOKEN": get_crypta_api_token(),
            "CUSTOM_YT_POOL": "crypta_graph_human_matching_v2",
        }
        if self.Parameters.is_experiment:
            env.update(
                {
                    "CRYPTA_EXP": "exp",
                    "CUSTOM_YT_POOL": "crypta_graph_human_matching_exp",
                }
            )
        return env

    def get_cmd(self):
        return [
            os.path.abspath("crypta-graph-task-runner"),
            "task",
            "run",
            self.Parameters.task_name,
        ] + list(self.task_parameters())
