import os

from sandbox import sdk2

from sandbox.projects.crypta.common.task import CryptaTask
from sandbox.projects.crypta.common.vault import (
    get_crypta_api_token,
    get_crypta_api_tvm_settings,
    get_statface_token,
    get_vault_item,
)


class CryptaLabBundle(sdk2.Resource):
    releasable = True


class CryptaLab(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaLabBundle
        graphite_monitoring_task_name = "crypta-lab"
        use_semaphore = False

    class Parameters(CryptaTask.Parameters):
        task_name = sdk2.parameters.String("Task name")
        task_args = sdk2.parameters.Dict("Task parameters")
        force = sdk2.parameters.Bool("Force", default=False)

    def task_parameters(self):
        for (key, value) in (self.Parameters.task_args or {}).items():
            yield "--arg"
            yield "{}={}".format(key, value)
        if self.Parameters.force:
            yield "--force"

    def get_additional_env(self):
        tvm_settings = get_crypta_api_tvm_settings(self.Parameters.environment)
        env = {
            'CRYPTA_ENVIRONMENT': self.Parameters.environment.replace('stable', 'production'),
            'STATFACE_TOKEN': get_statface_token(),
            'CRYPTA_API_TOKEN': get_crypta_api_token(),
            'YT_POOL': 'crypta_lab',
            'TVM_ID': str(tvm_settings['id']),
            'TVM_SECRET': tvm_settings['secret'],
            'AUDIENCE_TVM_SECRET': get_vault_item('sec-01dq7mfsrr2ess7xtrcnm0cvf5[client_secret]'),
        }

        return env

    @classmethod
    def get_juggler_service_for_task_name(cls, task):
        return "{}_{}".format(cls.get_class_juggler_service(), task)

    def get_juggler_service(self):
        return self.get_juggler_service_for_task_name(self.Parameters.task_name)

    def get_cmd(self):
        return [
            os.path.abspath("crypta-lab"),
            'run',
            '--task',
            self.Parameters.task_name,
        ] + list(self.task_parameters())
