import yaml

from sandbox import sdk2
from sandbox.projects.crypta.common import (
    helpers,
    task
)
from sandbox.projects.crypta.common import bundle
from sandbox.projects.crypta.lookalike.common import index_bundle


INDEX_FILENAME = "index.yaml"
CONFIG_FILENAME = "config.yaml"


class CryptaLookalikeTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = index_bundle.CryptaLookalikeIndexBundle
        bin_bundle_resource_type = None

    class Parameters(task.CryptaTask.Parameters):
        scope = sdk2.parameters.String(
            "Scope",
            required=True
        )
        mode = sdk2.parameters.String(
            "Mode",
            required=False
        )

    def on_prepare(self):
        super(CryptaLookalikeTask, self).on_prepare()

        with open(INDEX_FILENAME) as f:
            index = yaml.load(f)

        context = get_context(index, self.Parameters.scope, self.Parameters.mode)
        bundle.download_last_released_bundle(self.get_bin_bundle_resource_type(), self)
        helpers.render_template(CONFIG_FILENAME, environment=self.Parameters.environment, **context)

    def get_semaphore_name(self):
        semaphore_name_parts = [
            super(CryptaLookalikeTask, self).get_semaphore_name(),
            self.Parameters.scope,
        ]
        if self.Parameters.mode:
            semaphore_name_parts.append(self.Parameters.mode)

        return "_".join(semaphore_name_parts)

    def get_juggler_service(self):
        if self.Parameters.mode:
            return self.get_juggler_service_for_scope_and_mode(self.Parameters.scope, self.Parameters.mode)
        return self.get_juggler_service_for_scope(self.Parameters.scope)

    def get_graphite_monitoring_task_name(self):
        return "{}__{}".format(self.__class__.__name__, self.Parameters.scope)

    def get_bin_bundle_resource_type(self):
        return self.CryptaOptions.bin_bundle_resource_type

    @classmethod
    def get_juggler_service_for_scope(cls, scope):
        return "{}_{}".format(cls.get_class_juggler_service(), scope)

    @classmethod
    def get_juggler_service_for_scope_and_mode(cls, scope, mode):
        return "{}_{}_{}".format(cls.get_class_juggler_service(), scope, mode)


def get_context(index, scope, mode):
    for context in index:
        if context["scope"] == scope:
            if mode:
                context["mode"] = mode
            return context

    raise Exception("'{}' not found in index".format(scope))
