from sandbox import sdk2
from sandbox.projects.crypta.common import (
    helpers,
    vault,
)
from sandbox.projects.crypta.lookalike.common import task


CONFIG_FILENAME = "config.yaml"
TVM_SECRETS = {
    helpers.STABLE: "sec-01e2r2ebzz1n5y0sn6re7z80f2[client_secret]",
    helpers.TESTING: "sec-01e2r2ensmj8bwbdtfxp2redge[client_secret]",
}


class CryptaLookalikeLalRefresherBundle(sdk2.Resource):
    releasable = True


class CryptaLookalikeLalRefresherTask(task.CryptaLookalikeTask):
    class CryptaOptions(task.CryptaLookalikeTask.CryptaOptions):
        bin_bundle_resource_type = CryptaLookalikeLalRefresherBundle
        cmd = [
            helpers.get_abspath("crypta-lookalike-lal-refresher"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def get_additional_env(self):
        return {
            "TVM_SECRET": vault.get_vault_item(TVM_SECRETS[self.Parameters.environment]),
        }
