from sandbox import sdk2
from sandbox.projects.crypta.common import (
    helpers,
    vault,
)
from sandbox.projects.crypta.lookalike.common import task


CONFIG_FILENAME = "config.yaml"
TVM_SECRETS = {
    helpers.STABLE: "sec-01e3q1qq7fyxxvkyzvas40brkr[client_secret]",
    helpers.TESTING: "sec-01e3q1r4xthh8xh9dbx3cfabxb[client_secret]",
}


class CryptaLookalikeLalSynchronizerBundle(sdk2.Resource):
    releasable = True


class CryptaLookalikeLalSynchronizerTask(task.CryptaLookalikeTask):
    class CryptaOptions(task.CryptaLookalikeTask.CryptaOptions):
        bin_bundle_resource_type = CryptaLookalikeLalSynchronizerBundle
        cmd = [
            helpers.get_abspath("crypta-lookalike-lal-synchronizer"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def get_additional_env(self):
        return {
            "PQ_CLIENT_TVM_SECRET": vault.get_vault_item(TVM_SECRETS[self.Parameters.environment]),
        }
