import os
import shutil

from sandbox import sdk2
from sandbox.projects.crypta.common import (
    helpers,
    vault,
)
from sandbox.projects.crypta.lookalike.common import task


CONFIG_FILENAME = "config.yaml"
MAPPING_FILENAME = "mapping.json"
MAPPING_LOCAL_PATH = helpers.get_abspath(MAPPING_FILENAME)
TVM_SECRETS = {
    helpers.STABLE: "sec-01e3q1qq7fyxxvkyzvas40brkr[client_secret]",
    helpers.TESTING: "sec-01e3q1r4xthh8xh9dbx3cfabxb[client_secret]",
}


class CryptaLookalikeSegmentDssmApplierBundle(sdk2.Resource):
    releasable = True


class CryptaLookalikeParentToLalMapping(sdk2.Resource):
    releasable = True


class CryptaLookalikeSegmentDssmApplierTask(task.CryptaLookalikeTask):
    class CryptaOptions(task.CryptaLookalikeTask.CryptaOptions):
        bin_bundle_resource_type = CryptaLookalikeSegmentDssmApplierBundle
        cmd = [
            helpers.get_abspath("crypta-lookalike-segment-dssm-applier"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def on_execute(self):
        super(CryptaLookalikeSegmentDssmApplierTask, self).on_execute()

        if os.path.exists(MAPPING_LOCAL_PATH(self)):
            resource = CryptaLookalikeParentToLalMapping(
                self,
                "Parent ID to lal Id mapping",
                MAPPING_FILENAME,
                ttl=90,
                released=self.Parameters.environment,
            )
            resource_data = sdk2.ResourceData(resource)

            shutil.move(MAPPING_LOCAL_PATH(self), resource_data.path.as_posix())
            resource_data.ready()

            self.set_info("Found mapping local file at path: {}, wrote to resource".format(MAPPING_LOCAL_PATH(self)))
        else:
            self.set_info("Didn't find mapping local file at path: {}".format(MAPPING_LOCAL_PATH(self)))

    def get_additional_env(self):
        return {
            "MAPPING_LOCAL_PATH": MAPPING_LOCAL_PATH,
            "PQ_CLIENT_TVM_SECRET": vault.get_vault_item(TVM_SECRETS[self.Parameters.environment]),
        }
