import collections
import os

from sandbox import sdk2
from sandbox.projects.crypta.lookalike.common import task


CONFIG_FILENAME = "config.yaml"


class CryptaLookalikeDefaultUserSegmentsExporterBundle(sdk2.Resource):
    releasable = True


class CryptaLookalikeUserSegmentsExporterBundle(sdk2.Resource):
    releasable = True


CustomOptions = collections.namedtuple("CustomOptions", ["bundle", "bin_name"])


CUSTOM_BIN_OPTIONS = {
    "direct": CustomOptions(bundle=CryptaLookalikeUserSegmentsExporterBundle, bin_name="crypta-lookalike-user-segments-exporter")
}


class CryptaLookalikeUserSegmentsExporterTask(task.CryptaLookalikeTask):
    def get_bin_bundle_resource_type(self):
        custom_options = CUSTOM_BIN_OPTIONS.get(self.Parameters.scope)
        return custom_options.bundle if custom_options else CryptaLookalikeDefaultUserSegmentsExporterBundle

    def get_cmd(self):
        custom_options = CUSTOM_BIN_OPTIONS.get(self.Parameters.scope)
        bin_name = custom_options.bin_name if custom_options else "crypta-lookalike-default-user-segments-exporter"

        return [
            os.path.abspath(bin_name),
            "--config", os.path.abspath(CONFIG_FILENAME),
        ]
