from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
)


CONFIG_FILENAME = "config.yaml"


class CryptaLookalikeVisitLogParserBundle(sdk2.Resource):
    releasable = True


class CryptaLookalikeVisitLogParserTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaLookalikeVisitLogParserBundle
        templates = [CONFIG_FILENAME]
        cmd = [
            helpers.get_abspath("crypta-lookalike-visit-log-parser"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    class Parameters(task.CryptaTask.Parameters):
        log = sdk2.parameters.String(
            "Log",
            required=True
        )

    def render_template(self, template):
        helpers.render_template(template, environment=self.Parameters.environment, log=self.Parameters.log)

    def get_semaphore_name(self):
        return "{}_{}".format(super(CryptaLookalikeVisitLogParserTask, self).get_semaphore_name(), self.Parameters.log)

    def get_juggler_service(self):
        return self.get_juggler_service_for_log(self.Parameters.log)

    def get_graphite_monitoring_task_name(self):
        return "{}__{}".format(self.__class__.__name__, self.Parameters.log)

    @classmethod
    def get_juggler_service_for_log(cls, log):
        return "{}_{}".format(cls.get_class_juggler_service(), log)
