import os

from sandbox import sdk2
from sandbox.projects.crypta.common.task import CryptaTask


class CryptaLtpViewerIndexBundle(sdk2.Resource):

    releasable = True


class CryptaLtpViewerIndex(CryptaTask):

    class CryptaOptions(CryptaTask.CryptaOptions):

        bundle_resource_type = CryptaLtpViewerIndexBundle
        use_semaphore = False
        report_status_to_crypta_api = True

    class Parameters(CryptaTask.Parameters):

        index_path = sdk2.parameters.String(
            'YT path to ssd dynamic index',
            required=True
        )
        tmp_index_path = sdk2.parameters.String(
            'YT path to tmp hdd static table',
            required=True,
        )
        start_date = sdk2.parameters.String(
            'Date for start of update period',
            required=False,
        )
        end_date = sdk2.parameters.String(
            'Date for end of update period',
            required=False
        )
        min_history_date = sdk2.parameters.String(
            'Date for cleanup history',
            required=False
        )

    def get_additional_env(self):
        env_type = self.Parameters.environment.replace('stable', 'production').upper()
        return {
            'ENV_TYPE': env_type,
            'ENVIRONMENT': env_type.lower(),
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_POOL': 'crypta_graph'
        }

    def get_cmd(self):
        cmd = [
            os.path.abspath('main'),
            '--index-path', self.Parameters.index_path,
            '--tmp-index-path', self.Parameters.tmp_index_path,
        ]

        if self.Parameters.start_date:
            cmd.extend(['--start-date', self.Parameters.start_date])

        if self.Parameters.end_date:
            cmd.extend(['--end-date', self.Parameters.end_date])

        if self.Parameters.min_history_date:
            cmd.extend(['--min-history-date', self.Parameters.min_history_date])

        return cmd
