import os

from sandbox import sdk2

from sandbox.projects.crypta.common import (
    task
)


class CryptaMergeToBigbCollectorBundle(sdk2.Resource):
    releasable = True


class CryptaMergeToBigbCollectorTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaMergeToBigbCollectorBundle

    class Parameters(task.CryptaTask.Parameters):
        pool = sdk2.parameters.String("YT pool", required=True)
        fresh_dir = sdk2.parameters.String("Directory with fresh tables", required=True)
        output_dir = sdk2.parameters.String("Directory with collector queue", required=True)
        ttl_days = sdk2.parameters.Integer("Output table ttl in days", default=1, required=False)
        juggler_service_suffix = sdk2.parameters.String("Juggler service suffix", required=True)

    def get_cmd(self):
        cmd = [
            os.path.abspath("crypta-merge-to-bigb-collector"),
            "--yt-pool", self.Parameters.pool,
            "--fresh-dir", self.Parameters.fresh_dir,
            "--output-dir", self.Parameters.output_dir,
            "--ttl-days", str(self.Parameters.ttl_days),
        ]

        return cmd

    @classmethod
    def get_juggler_service_with_suffix(cls, suffix):
        return "{}_{}".format(cls.get_class_juggler_service(), suffix)

    def get_juggler_service(self):
        return self.get_juggler_service_with_suffix(self.Parameters.juggler_service_suffix)

    def get_semaphore_name(self):
        return "{}_{}".format(super(CryptaMergeToBigbCollectorTask, self).get_semaphore_name(), self.Parameters.juggler_service_suffix)
