import logging
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess


class CryptaRunLuigiTask(sdk2.Task):
    """Runs a task using Luigi CLI interface"""

    class Requirements(sdk2.Task.Requirements):
        """
        """
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        """
        """
        binary_resource_id = sdk2.parameters.String("Resource ID of binary", required=True)
        with sdk2.parameters.Group("Vault") as vault:
            VAULT_OWNER = sdk2.parameters.String("Owner of vault secrets", required=True)
            VAULT_YQL_TOKEN = sdk2.parameters.String("Name of YQL token secret", required=True)
            VAULT_YT_TOKEN = sdk2.parameters.String("Name of YT token secret", required=True)

        with sdk2.parameters.Group("Task") as task:
            TASK_NAME = sdk2.parameters.String("Task name", required=True)
            TASK_ARGS = sdk2.parameters.Dict("Task parameters")
            with sdk2.parameters.String("Environment type", required=True) as ENVIRONMENT:
                ENVIRONMENT.values.TESTING = ENVIRONMENT.Value('testing')
                ENVIRONMENT.values.PRODUCTION = ENVIRONMENT.Value('production')

    class Context(sdk2.Task.Context):
        pass

    def on_execute(self):
        """
        """
        logging.info('Using binary resource %s', self.Parameters.binary_resource_id)
        binary = self.get_binary()
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('luigi-task')) as process_log:
            subprocess.check_call(
                [binary, self.Parameters.TASK_NAME, '--local-scheduler'] + list(self.task_parameters()),
                shell=False,
                stdout=process_log.stdout,
                stderr=subprocess.STDOUT,
                env={
                    'YQL_TOKEN': self.get_secret(self.Parameters.VAULT_YQL_TOKEN),
                    'YT_TOKEN': self.get_secret(self.Parameters.VAULT_YT_TOKEN),
                    'ENVIRONMENT': self.get_environment(),
                }
            )

    def get_secret(self, what):
        """
        """
        return sdk2.Vault.data(self.Parameters.VAULT_OWNER, what)

    def get_environment(self):
        """
        """
        return self.Parameters.ENVIRONMENT.lower()

    def task_parameters(self):
        """
        """
        for (key, value) in (self.Parameters.TASK_ARGS or {}).items():
            yield '--' + key
            yield value

    def get_binary(self):
        """
        """
        resource = sdk2.Resource[self.Parameters.binary_resource_id]
        resource_data = sdk2.ResourceData(resource)
        return resource_data.path.as_posix()
