from sandbox import sdk2
import six

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault,
)


class CryptaRunUniversalBundle(task.CryptaTask):
    class Parameters(task.CryptaTask.Parameters):
        bundle_name = sdk2.parameters.String("Bundle name", required=True)
        cmd = sdk2.parameters.List("Command line arguments", required=True)
        additional_env = sdk2.parameters.Dict("Additional environment variables", required=False)
        secrets_env = sdk2.parameters.Dict("Environment variables with secrets", required=False)
        templates = sdk2.parameters.List("Templates", default=None)
        juggler_service = sdk2.parameters.String("Juggler service", required=False)
        semaphore_name = sdk2.parameters.String("Semaphore name", required=False)
        output_resources = sdk2.parameters.JSON("Output resources", required=False)
        template_rendering_context = sdk2.parameters.Dict("Template rendering context", required=False)

    def get_bundle_resource(self):
        if self.Parameters.override_basic_params and self.Parameters.overridden_bundle_resource:
            return self.Parameters.overridden_bundle_resource
        else:
            return helpers.get_last_released_universal_resource(self.Parameters.bundle_name, self.Parameters.environment)

    def get_cmd(self):
        return self.Parameters.cmd

    def get_additional_env(self):
        secrets_env = {env: vault.get_vault_item(secret_id) for env, secret_id in six.iteritems(self.Parameters.secrets_env)}
        return dict(self.Parameters.additional_env, **secrets_env)

    def get_template_rendering_context(self):
        return self.Parameters.template_rendering_context

    def get_templates(self):
        return self.Parameters.templates

    def get_juggler_service(self):
        return self.Parameters.juggler_service

    def get_use_semaphore(self):
        return bool(self.Parameters.semaphore_name)

    def get_semaphore_name(self):
        return self.Parameters.semaphore_name

    def get_output_resources(self):
        output_resources = self.Parameters.output_resources or []
        return [task.OutputResourceConfig(**x) for x in output_resources]
