from sandbox.projects.crypta.common import (
    helpers,
    task,
)
import sandbox.projects.crypta.s2s.common.task as common_task


CONFIG_FILE = "calc_stats_config.yaml"
INDEX_FILE = "index.yaml"


class CryptaS2sCalcStatsTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = common_task.CryptaS2sBundle
        templates = [INDEX_FILE, CONFIG_FILE]
        cmd = [
            helpers.get_abspath("crypta-s2s-calc-stats"),
            "--config", helpers.get_abspath(CONFIG_FILE),
            "--index", helpers.get_abspath(INDEX_FILE),
        ]
