import yaml

from sandbox import sdk2
from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault,
)


INDEX_FILENAME = "index.yaml"
CONFIG_FILENAME = "config.yaml"


class CryptaS2sBundle(sdk2.Resource):
    releasable = True


class CryptaS2sTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaS2sBundle
        templates = [INDEX_FILENAME]

    class Parameters(task.CryptaTask.Parameters):
        client = sdk2.parameters.String(
            "Client",
            required=True
        )

    def get_semaphore_name(self):
        return "{}_{}".format(super(CryptaS2sTask, self).get_semaphore_name(), self.Parameters.client)

    def get_juggler_service(self):
        return self.get_juggler_service_for_client(self.Parameters.client)

    def on_prepare(self):
        super(CryptaS2sTask, self).on_prepare()

        context = get_context(self.Parameters.client)
        helpers.render_template(CONFIG_FILENAME, environment=self.Parameters.environment, **context)

    @classmethod
    def get_juggler_service_for_client(cls, client):
        return "{}_{}".format(cls.get_class_juggler_service(), client)

    def get_additional_env(self):
        context = get_context(self.Parameters.client)
        secrets = context.get("secrets", {})
        secrets["POSTBACK_PASS_PHRASE"] = "sec-01fgbyrvxk9ak1b6y0zehmwwr3[pass_phrase]"

        if context["provider"]["type"] == "google_sheets_provider":
            secrets["GOOGLE_SERVICE_ACCOUNT_KEY"] = "sec-01fqby197y3s5kd0s08zgfqn71[key]"

        return {k: vault.get_vault_item(v) for k, v in secrets.iteritems()}


def get_context(client):
    with open(INDEX_FILENAME) as f:
        index = yaml.load(f)

    for context in index:
        if context["client"] == client:
            return context

    raise Exception("'{}' not found in index".format(client))
