import os

from sandbox.common.types import (
    client,
    misc,
)

from sandbox.projects.crypta.s2s.common import task


class CryptaS2sTransferConversionsToYtTask(task.CryptaS2sTask):
    class Requirements(task.CryptaS2sTask.Requirements):
        dns = misc.DnsType.DNS64
        client_tags = client.Tag.SAS

    def get_cmd(self):
        return [
            os.path.abspath("crypta-s2s-transfer-conversions-to-yt"),
            "--config", os.path.abspath(task.CONFIG_FILENAME),
        ]
