from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault,
)


CONFIG_FILENAME = "config.yaml"
CRYPTA_SIBERIA_EXPIRATOR_TVM_SECRET = {
    helpers.STABLE: "sec-01e0ta56nt6tkwj2rv36mcys79[client_secret]",
    helpers.TESTING: "sec-01e0ta4jz519khqptwa32nchad[client_secret]",
}


class CryptaSiberiaExpiratorBundle(sdk2.Resource):
    releasable = True


class CryptaSiberiaExpiratorTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaSiberiaExpiratorBundle
        templates = [CONFIG_FILENAME]
        cmd = [
            helpers.get_abspath("crypta-siberia-expirator"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def get_additional_env(self):
        return {
            "YDB_TOKEN": vault.get_ydb_token(self.Parameters.environment),
            "TVM_SECRET": vault.get_vault_item(CRYPTA_SIBERIA_EXPIRATOR_TVM_SECRET[self.Parameters.environment]),
        }
