import os

from sandbox import sdk2
from sandbox.projects.common.ya_deploy import release_integration

from sandbox.projects.crypta.common import (
    helpers,
    task,
)


CONFIG_FILENAME = "config.yaml"


class CryptaSiberiaMakeUserDataEncodedBundle(sdk2.Resource):
    releasable = True


class CryptaSiberiaEncodedUserDataInfo(sdk2.Resource):
    releasable = True


class CryptaSiberiaMakeUserDataEncodedTask(task.CryptaTask, release_integration.ReleaseToYaDeployTask2):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaSiberiaMakeUserDataEncodedBundle
        templates = [CONFIG_FILENAME]
        cmd = [
            helpers.get_abspath("crypta-make-user-data-encoded"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def on_execute(self):
        super(CryptaSiberiaMakeUserDataEncodedTask, self).on_execute()

        release_file = "encoded_user_data_release_info.json"
        if os.path.exists(release_file):
            resource = CryptaSiberiaEncodedUserDataInfo(
                self,
                "Encoded user data release info",
                release_file,
                ttl="7",
            )

            sdk2.ResourceData(resource).ready()

            release_integration.ReleaseToYaDeployTask2.on_release(
                self,
                {
                    "release_status": self.Parameters.environment,
                    "releaser": self.owner,
                    "release_comments": "automatic release",
                    "release_subject": "",
                    "email_notifications": {"cc": [], "to": []},
                },
            )
