from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault,
)


CONFIG_FILENAME = "config.yaml"


class CryptaSiberiaMatchingTableUploaderBundle(sdk2.Resource):
    releasable = True


class CryptaSiberiaMatchingTableUploaderTask(task.CryptaTask):
    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaSiberiaMatchingTableUploaderBundle
        templates = [CONFIG_FILENAME]
        cmd = [
            helpers.get_abspath("crypta-siberia-matching-table-uploader"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def get_additional_env(self):
        return {
            "YDB_TOKEN": vault.get_ydb_token(self.Parameters.environment),
        }
