from sandbox import sdk2

from sandbox.projects.crypta.common import (
    helpers,
    task,
    vault,
)


CONFIG_FILENAME = "config.yaml"
CRYPTA_CDP_CLIENTS_UPLOADER_TVM_SECRET = {
    helpers.STABLE: "sec-01dw7c0vnqabsdr2h078k6p93c[client_secret]",
    helpers.TESTING: "sec-01dw7c1b27d68rh2sw1xp0ww9x[client_secret]",
}


class CryptaSiberiaUploadUsersBundle(sdk2.Resource):
    releasable = True


class CryptaSiberiaUploadUsersTask(task.CryptaTask):
    class Parameters(task.CryptaTask.Parameters):
        login = sdk2.parameters.String(
            "User login",
            required=True
        )
        user_set_id = sdk2.parameters.String(
            "User set id",
            required=True
        )
        src_table = sdk2.parameters.String(
            "YT table to upload",
            required=True
        )
        fields_id_types = sdk2.parameters.Dict(
            "Id types of fields",
            default={}
        )

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaSiberiaUploadUsersBundle
        use_semaphore = False

        cmd = [
            helpers.get_abspath("crypta-siberia-upload-users"),
            "--config", helpers.get_abspath(CONFIG_FILENAME),
        ]

    def on_prepare(self):
        super(CryptaSiberiaUploadUsersTask, self).on_prepare()

        helpers.render_template(CONFIG_FILENAME,
                                environment=self.Parameters.environment,
                                login=self.Parameters.login,
                                user_set_id=self.Parameters.user_set_id,
                                src_table=self.Parameters.src_table,
                                fields_id_types=self.Parameters.fields_id_types)

    def get_additional_env(self):
        return {
            "TVM_SECRET": vault.get_vault_item(CRYPTA_CDP_CLIENTS_UPLOADER_TVM_SECRET[self.Parameters.environment])
        }
