import os

from sandbox import sdk2

from sandbox.projects.crypta.common import (
    task,
    vault,
)


CONFIG_FILENAME = "config.yaml"


class CryptaSiberiaUserDataUploaderBundle(sdk2.Resource):
    releasable = True


class CryptaSiberiaUserDataUploaderTask(task.CryptaTask):
    class Parameters(task.CryptaTask.Parameters):
        custom_version = sdk2.parameters.String("Custom version", required=False, default="")

    class CryptaOptions(task.CryptaTask.CryptaOptions):
        bundle_resource_type = CryptaSiberiaUserDataUploaderBundle
        templates = [CONFIG_FILENAME]

    def get_additional_env(self):
        return {
            "YDB_TOKEN": vault.get_ydb_token(self.Parameters.environment),
        }

    def get_cmd(self):
        cmd = [
            os.path.abspath("crypta-siberia-user-data-uploader"),
            "--config", os.path.abspath(CONFIG_FILENAME),
        ]

        if self.Parameters.custom_version:
            cmd += ["--version", self.Parameters.custom_version]

        return cmd
