# coding: utf-8

from sandbox import sdk2

_device_types = ['cpu', 'cuda']
_neural_net_types = ['general', 'detection', 'faces', 'ocr', 'superresolution']


class CV_NEURAL_NET_BODY(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = ['splinter', 'konev', 'robot-images-sandbox']

    version = sdk2.parameters.Integer("Neural net version", required=True)

    device_type = sdk2.parameters.String(
        "Device type for nn model",
        default="cpu",
        choices=_device_types,
        required=True)

    neural_net_type = sdk2.parameters.String(
        "Neural net type",
        default='general',
        choices=_neural_net_types,
        required=True
    )
