# coding: utf-8

from sandbox import sdk2

AbstractResource = sdk2.resource.AbstractResource


class CV_DUPKV_STREAM_APP(AbstractResource):
    """
       Исполняемый файл стриминг-интерфейса дубликатов поверх key-value
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['volynkin']
    arcadia_build_path = 'cv/semidups/dups_over_kv/stream_app/stream_app'


class CvdupSamplingTool(sdk2.Resource):
    """
       Tool for sampling
    """
    auto_backup = True
    releasable = True
    releasers = ['igorp86', 'volynkin', 'robot-testenv']
    release_subscribers = ['igorp86', 'volynkin']
    any_arch = False
    executable = True
    arcadia_build_path = 'cv/semidup2/tools/sampler/sampler'


class CvdupImageExtractorTool(sdk2.Resource):
    """
       Tool for extracting images from datasets
    """
    auto_backup = True
    releasable = True
    releasers = ['igorp86', 'volynkin', 'robot-testenv']
    release_subscribers = ['igorp86', 'volynkin']
    any_arch = False
    executable = True
    arcadia_build_path = 'cv/semidup2/tools/thumb_extractor/thumb_extractor'


class CvdupAcceptanceJson(sdk2.Resource):
    """
    any JSON file
    """
    ttl = 'inf'
    any_arch = False
    releasable = False


class CvdupAcceptanceImageUrlPairsJson(sdk2.Resource):
    """
    JSON file, contains image url pairs
    """
    ttl = 'inf'
    any_arch = False
    releasable = False


class CvdupAcceptanceTolokaEstimatesJson(sdk2.Resource):
    """
    JSON file, contains image url pairs, and toloka semidups estimates
    """
    ttl = 'inf'
    any_arch = False
    releasable = False


class CvdupAcceptanceStateMetricsJson(sdk2.Resource):
    """
    JSON file, contains semidups state metrics, calculated using toloka estimates
    """
    ttl = 'inf'
    any_arch = False
    releasable = False


class CvdupAcceptanceSamplerLaunchStatsJson(sdk2.Resource):
    """
    JSON file, contains cvdup sampling tool launch stats
    """
    ttl = 'inf'
    any_arch = False
    releasable = False
