# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.common.errors import TaskFailure
import logging
import requests


class WaitBitbucketPullRequestMerge(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        disk_space = 1024  # 1GB
        ram = 2048  # 2GB

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        pull_request_id = sdk2.parameters.String("Pull request ID", required=True)

    def on_execute(self):
        bitbucket_token = sdk2.Vault.data("DATA_TRANSFER", "CI_COMMON_BITBUCKET_TOKEN")
        request_headers = {
            'Authorization':  'Bearer {}'.format(bitbucket_token),
            'Accept':         'application/json',
        }
        pr_url = 'https://bb.yandex-team.ru/projects/CLOUD/repos/cloud-go/pull-requests/{}'.format(self.Parameters.pull_request_id)

        logging.info('GET {}'.format(pr_url))
        response = requests.get(pr_url, headers=request_headers).json()
        logging.info('GET {} response: {}'.format(pr_url, response))

        if response['open']:
            logging.info('Pull request is still open, wait 5 minutes')
            raise sdk2.WaitTime(5 * 60)  # 5 minutes
        elif response['state'] == 'MERGED':
            logging.info('Pull request is merged. Exit')
            return
        else:
            raise TaskFailure('Unexpected pull request state: {}'.format(response['state']))
