from sandbox import sdk2
import sandbox.projects.resource_types.releasers as rr


class DatalensResourceBase(sdk2.Resource):
    releasable = True
    releasers = rr.datalens_releasers
    sync_upload_to_mds = True


class DatalensPrepareUsageTrackingLogs(DatalensResourceBase):
    """
    Script for filtering logs in YT
    """
    executable = True


class DatalensLoadUSEntriesKeysToCH(DatalensResourceBase):
    """
    Script for loading US entries keys into CH for usage tracking
    """
    executable = True


class DatalensLoadBillingInfoToCH(DatalensResourceBase):
    """
    Script for loading billing info into CH for usage tracking
    """
    executable = True


class DatalensClickHouseExecutor(DatalensResourceBase):
    """
    Script for executing one of the prepared parametrizable queries
    """
    executable = True


class DatalensUpdateGeoDictsOnYT(DatalensResourceBase):
    """
    Script for loading geo dictionaries on YT
    """
    executable = True
