# coding=utf-8

import datetime
import time


class Job:
    def __init__(self):
        self.job_id = None
        self.hitman_job_status = None
        self.hitman_project = None
        self.hitman_process = None

        self.workflow_at_start = None
        self.has_single_execution = None

        self.has_WORKFLOW_START = False
        self.WORKFLOW_START_ts = None
        self.WORKFLOW_START_dt = None

        self.has_WORKFLOW_END = False
        self.WORKFLOW_END_ts = None
        self.WORKFLOW_END_dt = None

        # SCREENSHOT
        self.has_MOBILE_SCREENSHOT_START_TS = False
        self.MOBILE_SCREENSHOT_START_TS = None
        self.MOBILE_SCREENSHOT_START_TS_dt = None

        self.has_MOBILE_SCREENSHOT_END_TS = False
        self.MOBILE_SCREENSHOT_END_TS = None
        self.MOBILE_SCREENSHOT_END_TS_dt = None

        self.MOBILE_SCREENSHOT_DURATION = None
        self.MOBILE_SCREENSHOT_DURATION_ts = None

        self.MOBILE_SCREENSHOT_SUCCESS_COUNT = None
        self.MOBILE_SCREENSHOT_ERROR_COUNT = None

        self.has_DESKTOP_SCREENSHOT_START_TS = False
        self.DESKTOP_SCREENSHOT_START_TS = None
        self.DESKTOP_SCREENSHOT_START_TS_dt = None

        self.has_DESKTOP_SCREENSHOT_END_TS = False
        self.DESKTOP_SCREENSHOT_END_TS = None
        self.DESKTOP_SCREENSHOT_END_TS_dt = None

        self.DESKTOP_SCREENSHOT_DURATION = None
        self.DESKTOP_SCREENSHOT_DURATION_ts = None

        self.DESKTOP_SCREENSHOT_SUCCESS_COUNT = None
        self.DESKTOP_SCREENSHOT_ERROR_COUNT = None

        # ASSESSMENT
        self.has_ASSESSMENT_START_TS = False
        self.ASSESSMENT_START_TS = None
        self.ASSESSMENT_START_TS_dt = None

        self.has_ASSESSMENT_END_TS = False
        self.ASSESSMENT_END_TS = None
        self.ASSESSMENT_END_TS_dt = None

        self.ASSESSMENT_DURATION = None
        self.ASSESSMENT_DURATION_ts = None

        # HONEYPOTS
        self.has_GET_HONEYPOTS_START_TS = False
        self.GET_HONEYPOTS_START_TS = None
        self.GET_HONEYPOTS_START_TS_dt = None

        self.has_GET_HONEYPOTS_END_TS = False
        self.GET_HONEYPOTS_END_TS = None
        self.GET_HONEYPOTS_END_TS_dt = None

        self.GET_HONEYPOTS_DURATION = None
        self.GET_HONEYPOTS_DURATION_ts = None

        # CRITICAL SECTION
        self.has_CRITICAL_SECTION_START_TS = False
        self.CRITICAL_SECTION_START_TS = None
        self.CRITICAL_SECTION_START_TS_dt = None

        self.has_CRITICAL_SECTION_END_TS = False
        self.CRITICAL_SECTION_END_TS = None
        self.CRITICAL_SECTION_END_TS_dt = None

        self.CRITICAL_SECTION_DURATION = None
        self.CRITICAL_SECTION_DURATION_ts = None

        self.STORED_ASSESSMENTS_SIZE = None

        self.df = None

    def parse_workflow_start(self, df):
        workflow_start_df = df[df["data-type"] == "WORKFLOW_START"]
        if workflow_start_df.shape[0] > 0:
            self.has_WORKFLOW_START = True
            self.workflow_at_start = workflow_start_df["workflow-uid"].values[0]
            self.WORKFLOW_START_ts = int(workflow_start_df["timestamp-raw"].values[0]) / 1000.
            self.WORKFLOW_START_dt = datetime.datetime.fromtimestamp(self.WORKFLOW_START_ts)

            self.job_id = workflow_start_df["hitman-job"].values[0]
            self.hitman_project = workflow_start_df["hitman-project"].values[0]
            self.hitman_process = workflow_start_df["hitman-process"].values[0]

    def parse_critical_section(self, df):
        critical_section_start_df = df[df["data-type"] == "CRITICAL_SECTION_START"]
        if critical_section_start_df.shape[0] > 0:
            self.has_CRITICAL_SECTION_START_TS = True
            self.CRITICAL_SECTION_START_TS = int(critical_section_start_df["timestamp-raw"].values[0]) / 1000.
            self.CRITICAL_SECTION_START_TS_dt = datetime.datetime.fromtimestamp(self.CRITICAL_SECTION_START_TS)

        critical_section_end_df = df[df["data-type"] == "CRITICAL_SECTION_END"]
        if critical_section_end_df.shape[0] > 0:
            self.has_CRITICAL_SECTION_END_TS = True
            self.CRITICAL_SECTION_END_TS = int(critical_section_end_df["timestamp-raw"].values[0]) / 1000.
            self.CRITICAL_SECTION_END_TS_dt = datetime.datetime.fromtimestamp(self.CRITICAL_SECTION_END_TS)

        if self.has_CRITICAL_SECTION_START_TS and self.has_CRITICAL_SECTION_END_TS:
            self.CRITICAL_SECTION_DURATION = self.CRITICAL_SECTION_END_TS_dt - self.CRITICAL_SECTION_START_TS_dt
            self.CRITICAL_SECTION_DURATION_ts = self.CRITICAL_SECTION_DURATION.total_seconds()

    def parse_honeypots(self, df):
        get_honeypots_start_df = df[df["data-type"] == "GET_HONEYPOTS_START"]
        if get_honeypots_start_df.shape[0] > 0:
            self.has_GET_HONEYPOTS_START_TS = True
            self.GET_HONEYPOTS_START_TS = int(get_honeypots_start_df["timestamp-raw"].values[0]) / 1000.
            self.GET_HONEYPOTS_START_TS_dt = datetime.datetime.fromtimestamp(self.GET_HONEYPOTS_START_TS)

        get_honeypots_end_df = df[df["data-type"] == "GET_HONEYPOTS_END"]
        if get_honeypots_end_df.shape[0] > 0:
            self.has_GET_HONEYPOTS_END_TS = True
            self.GET_HONEYPOTS_END_TS = int(get_honeypots_end_df["timestamp-raw"].values[0]) / 1000.
            self.GET_HONEYPOTS_END_TS_dt = datetime.datetime.fromtimestamp(self.GET_HONEYPOTS_END_TS)

        if self.has_GET_HONEYPOTS_START_TS and self.has_GET_HONEYPOTS_END_TS:
            self.GET_HONEYPOTS_DURATION = self.GET_HONEYPOTS_END_TS_dt - self.GET_HONEYPOTS_START_TS_dt
            self.GET_HONEYPOTS_DURATION_ts = self.GET_HONEYPOTS_DURATION.total_seconds()

    def parse_mobile_screenshots(self, df):
        mobile_screenshots_start_df = df[df["data-type"] == "MOBILE_SCREENSHOTS_START"]
        if mobile_screenshots_start_df.shape[0] > 0:
            self.has_MOBILE_SCREENSHOT_START_TS = True
            self.MOBILE_SCREENSHOT_START_TS = int(mobile_screenshots_start_df["timestamp-raw"].values[0]) / 1000.
            self.MOBILE_SCREENSHOT_START_TS_dt = datetime.datetime.fromtimestamp(self.MOBILE_SCREENSHOT_START_TS)

        mobile_screenshots_end_df = df[df["data-type"] == "MOBILE_SCREENSHOTS_END"]
        if mobile_screenshots_end_df.shape[0] > 0:
            self.has_MOBILE_SCREENSHOT_END_TS = True
            self.MOBILE_SCREENSHOT_END_TS = int(mobile_screenshots_end_df["timestamp-raw"].values[0]) / 1000.
            self.MOBILE_SCREENSHOT_END_TS_dt = datetime.datetime.fromtimestamp(self.MOBILE_SCREENSHOT_END_TS)

            data = mobile_screenshots_end_df["data"].values[0]
            if data:
                for item in data:
                    self.MOBILE_SCREENSHOT_SUCCESS_COUNT = item["success"]
                    self.MOBILE_SCREENSHOT_ERROR_COUNT = item["error"]

        if self.has_MOBILE_SCREENSHOT_START_TS and self.has_MOBILE_SCREENSHOT_END_TS:
            self.MOBILE_SCREENSHOT_DURATION = self.MOBILE_SCREENSHOT_END_TS_dt - self.MOBILE_SCREENSHOT_START_TS_dt
            self.MOBILE_SCREENSHOT_DURATION_ts = self.MOBILE_SCREENSHOT_DURATION.total_seconds()

    def parse_desktop_screenshots(self, df):
        desktop_screenshots_start_df = df[df["data-type"] == "DESKTOP_SCREENSHOTS_START"]
        if desktop_screenshots_start_df.shape[0] > 0:
            self.has_DESKTOP_SCREENSHOT_START_TS = True
            self.DESKTOP_SCREENSHOT_START_TS = int(desktop_screenshots_start_df["timestamp-raw"].values[0]) / 1000.
            self.DESKTOP_SCREENSHOT_START_TS_dt = datetime.datetime.fromtimestamp(self.DESKTOP_SCREENSHOT_START_TS)

        desktop_screenshots_end_df = df[df["data-type"] == "DESKTOP_SCREENSHOTS_END"]
        if desktop_screenshots_end_df.shape[0] > 0:
            self.has_DESKTOP_SCREENSHOT_END_TS = True
            self.DESKTOP_SCREENSHOT_END_TS = int(desktop_screenshots_end_df["timestamp-raw"].values[0]) / 1000.
            self.DESKTOP_SCREENSHOT_END_TS_dt = datetime.datetime.fromtimestamp(self.DESKTOP_SCREENSHOT_END_TS)

            data = desktop_screenshots_end_df["data"].values[0]
            if data:
                for item in data:
                    self.DESKTOP_SCREENSHOT_SUCCESS_COUNT = item["success"]
                    self.DESKTOP_SCREENSHOT_ERROR_COUNT = item["error"]

        if self.has_DESKTOP_SCREENSHOT_START_TS and self.has_DESKTOP_SCREENSHOT_END_TS:
            self.DESKTOP_SCREENSHOT_DURATION = self.DESKTOP_SCREENSHOT_END_TS_dt - self.DESKTOP_SCREENSHOT_START_TS_dt
            self.DESKTOP_SCREENSHOT_DURATION_ts = self.DESKTOP_SCREENSHOT_DURATION.total_seconds()

    def parse_assessment(self, df):
        assessment_start_df = df[df["data-type"] == "ASSESSMENT_START"]
        if assessment_start_df.shape[0] > 0:
            self.has_ASSESSMENT_START_TS = True
            self.ASSESSMENT_START_TS = int(assessment_start_df["timestamp-raw"].values[0]) / 1000.
            self.ASSESSMENT_START_TS_dt = datetime.datetime.fromtimestamp(self.ASSESSMENT_START_TS)

        assessment_end_df = df[df["data-type"] == "ASSESSMENT_END"]
        if assessment_end_df.shape[0] > 0:
            self.has_ASSESSMENT_END_TS = True
            self.ASSESSMENT_END_TS = int(assessment_end_df["timestamp-raw"].values[0]) / 1000.
            self.ASSESSMENT_END_TS_dt = datetime.datetime.fromtimestamp(self.ASSESSMENT_END_TS)

        if self.has_ASSESSMENT_START_TS and self.has_ASSESSMENT_END_TS:
            self.ASSESSMENT_DURATION = self.ASSESSMENT_END_TS_dt - self.ASSESSMENT_START_TS_dt
            self.ASSESSMENT_DURATION_ts = self.ASSESSMENT_DURATION.total_seconds()

    def parse_stored_assessments_size(self, df):
        stored_assessments_size_df = df[df["data-type"] == "STORED_ASSESSMENTS_SIZE"]
        if stored_assessments_size_df.shape[0] > 0:
            data = stored_assessments_size_df["data"].values[0]
            for item in data:
                self.STORED_ASSESSMENTS_SIZE = item["size"]

    def set_workflow_end(self, date_time_str):
        if date_time_str:
            time_format = "%Y-%m-%dT%H:%M:%S.%fZ"
            dt = datetime.datetime.strptime(date_time_str, time_format)
            ts = time.mktime(dt.timetuple())

            self.has_WORKFLOW_END = True
            self.WORKFLOW_END_ts = ts
            self.WORKFLOW_END_dt = datetime.datetime.fromtimestamp(self.WORKFLOW_END_ts)

    @staticmethod
    def from_df(df):
        job = Job()

        job.parse_workflow_start(df)
        job.parse_desktop_screenshots(df)
        job.parse_mobile_screenshots(df)
        job.parse_honeypots(df)
        job.parse_critical_section(df)
        job.parse_assessment(df)
        job.parse_stored_assessments_size(df)

        return job

    def to_dyn_table_item(self):
        value = {
            'start-ts': self.WORKFLOW_START_ts,
            'end-ts': self.WORKFLOW_END_ts,

            'desktop-screenshot-start-ts': self.DESKTOP_SCREENSHOT_START_TS,
            'desktop-screenshot-end-ts': self.DESKTOP_SCREENSHOT_END_TS,
            'desktop-screenshot-duration-ts': self.DESKTOP_SCREENSHOT_DURATION_ts,
            'desktop-screenshot-success-count': self.DESKTOP_SCREENSHOT_SUCCESS_COUNT,
            'desktop-screenshot-error-count': self.DESKTOP_SCREENSHOT_ERROR_COUNT,

            'mobile-screenshot-start-ts': self.MOBILE_SCREENSHOT_START_TS,
            'mobile-screenshot-end-ts': self.MOBILE_SCREENSHOT_END_TS,
            'mobile-screenshot-duration-ts': self.MOBILE_SCREENSHOT_DURATION_ts,
            'mobile-screenshot-success-count': self.MOBILE_SCREENSHOT_SUCCESS_COUNT,
            'mobile-screenshot-error-count': self.MOBILE_SCREENSHOT_ERROR_COUNT,

            'assessment-start-ts': self.ASSESSMENT_START_TS,
            'assessment-end-ts': self.ASSESSMENT_END_TS,
            'assessment-duration-ts': self.ASSESSMENT_DURATION_ts,

            'get-honeypots-start-ts': self.GET_HONEYPOTS_START_TS,
            'get-honeypots-end-ts': self.GET_HONEYPOTS_END_TS,
            'get-honeypots-duration-ts': self.GET_HONEYPOTS_DURATION_ts,

            'critical-section-start-ts': self.CRITICAL_SECTION_START_TS,
            'critical-section-end-ts': self.CRITICAL_SECTION_END_TS,
            'critical-section-duration-ts': self.CRITICAL_SECTION_DURATION_ts,

            'stored-assessments-size': self.STORED_ASSESSMENTS_SIZE,
        }
        item = {
            'hitman_project': self.hitman_project,
            'hitman_process': self.hitman_process,
            'hitman_job': self.job_id,
            'status': self.hitman_job_status,
            'value': value
        }
        return item
