# coding=utf-8


def batch(lst, n=1):
    l = len(lst)
    for ndx in range(0, l, n):
        yield lst[ndx:ndx + n]


def batch_update_job_statuses(jobs, batch_size, hitman_api_helper):
    for jobs_batch in batch(jobs, batch_size):
        job_ids = [job.job_id for job in jobs_batch if job.job_id]
        statuses = hitman_api_helper.get_status_batch(job_ids)
        for job in jobs_batch:
            if job.job_id:
                status = statuses[job.job_id]
                job.hitman_job_status = status["status"]
                job.set_workflow_end(status["finish_ts"])
