# coding=utf-8

import logging

import sandbox.common.types.task as ctt
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.dc3.dc_release.common import dc_release_from_branch
from sandbox.projects.dc3.dc_release.dc_release_mac import DcReleaseMac
from sandbox.projects.dc3.dc_release.dc_release_win import DcReleaseWin


class DcRelease(sdk2.Task):
    class Requirements(sdk2.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        _branch_params = dc_release_from_branch.dc_release_from_branch_task_parameters()

        # binary task release parameters
        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.CheckGroup('Платформы', required=True) as platforms:
            platforms.values.win = platforms.Value('Windows', checked=True)
            platforms.values.mac = platforms.Value('Mac OS', checked=True)

    def _get_child_tasks(self):
        tasks = []
        if "win" in self.Parameters.platforms:
            tasks.append(DcReleaseWin)
        if "mac" in self.Parameters.platforms:
            tasks.append(DcReleaseMac)
        return tasks

    def _run_child_tasks(self, tasks):
        subtasks = []

        for Task in tasks:
            logging.debug("Creating subtask {}".format(Task.__name__))
            subtask = Task(
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                tokens=self.Parameters.tokens,
                arc_branch=self.Parameters.arc_branch,
                binary_executor_release_type=self.Parameters.binary_executor_release_type,
                arcadia_url=self.Parameters.arcadia_url
            )

            subtasks.append(subtask.save().enqueue())

        return subtasks

    def on_execute(self):
        with self.memoize_stage.create_children:
            sub_tasks = self._run_child_tasks(self._get_child_tasks())
            raise sdk2.WaitTask(sub_tasks, ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, wait_all=True)

        logging.info("Child tasks are finished")
