# coding=utf-8

import logging

from sandbox.projects.common import binary_task
from sandbox import sdk2

def dc_release_from_branch_task_parameters():
    class _DCReleaseFromBranchTaskParameters(sdk2.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "YAV secret id",
            default="sec-01crdc7rw80nvwge7aej7ztdnv"
        )
        arcadia_url = sdk2.parameters.ArcadiaUrl('Arcadia Url', default='arcadia-arc:/#trunk')

        with sdk2.parameters.Group('Настройки репозитория') as repo_block:
            arc_branch = sdk2.parameters.String(
                'Build branch',
                default='trunk',
                required=True,
                description='Имя ветки, из которой должна происходить сборка'
            )

    return _DCReleaseFromBranchTaskParameters()


class DCReleaseFromBranchTaskMixin(binary_task.LastBinaryTaskRelease):
    """
    Mixin class to automatically prepare repo for release.
    Should be used together with `dc_release_branch_task_parameters`.

    Usage example:
    >>> class MyTask(DCReleaseFromBranchTaskMixin):
    >>>    class Parameters(sdk2.Task.Parameters):
    >>>        ...
    >>>        _branch_params = dc_release_from_branch_task_parameters()
    """

    def on_prepare(self):
        logging.debug('Preparing task...')
