import textwrap

from sandbox.sandboxsdk import parameters
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.ya_deploy import release_integration
from sandbox import sdk2


class DeployQueueControllerLayer(sdk2.Resource):
    """
    Ya.Deploy DQCtl layer
    """
    releasable = True
    any_arch = False
    releasers = ['torkve', 'reddi', 'alonger', 'DRUG-RELEASERS', 'NANNY']
    auto_backup = True


class BuildDeployQueueController(YaPackage.YaPackage):
    """
        Build Ya.Deploy release integration deploy queue controller
    """
    type = 'BUILD_DEPLOY_QUEUE_CONTROLLER'
    release_to = []

    class ServiceVersion(parameters.SandboxStringParameter):
        name = 'service_version'
        description = 'Version to build'
        required = True

    input_parameters = [
        YaPackage.parameters.ArcadiaUrl,
        ServiceVersion,
        YaPackage.parameters.DoNotRemoveResources,
        YaPackage.RunTestsParameter,
    ]

    execution_space = 2000

    def on_enqueue(self):
        self.ctx[YaPackage.parameters.BuildType.name] = YaPackage.RELEASE
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.TARBALL
        self.ctx[YaPackage.PackagesParameter.name] = "infra/deploy_queue_controller/build.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = DeployQueueControllerLayer.name
        self.ctx[YaPackage.PublishPackageParameter.name] = False
        self.ctx[release_integration.ReleaseToYaDeployParameter.name] = True

        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[YaPackage.UseNewFormatParameter.name] = True
        self.ctx[YaPackage.parameters.CheckoutParameter.name] = True

        version = self.ctx[BuildDeployQueueController.ServiceVersion.name]
        self.ctx[YaPackage.CustomVersionParameter.name] = version
        self.ctx[YaPackage.PackageResourceDescriptionParameter.name] = {"infra/deploy_queue_controller/build.json": "dqctl-%s" % (version,)}

        YaPackage.YaPackage.on_enqueue(self)

    @property
    def release_template(self):
        subject = 'dqctl ' + str(self.ctx[BuildDeployQueueController.ServiceVersion.name])

        return self.ReleaseTemplate(
            [],
            subject,
            textwrap.dedent('''\
                Changelog:
                  ** Bugs
                     * DEPLOY-XXX: bug #1
                  ** Features
                     * DEPLOY-YYY: feature #1
            '''),
            ['testing', 'prestable', 'stable'],
        )


__Task__ = BuildDeployQueueController
