import textwrap

from sandbox.sandboxsdk import parameters
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.ya_deploy import release_integration
from sandbox import sdk2


class DproxyLayer(sdk2.Resource):
    """
    Ya.Deploy dproxy layer
    """
    releasable = True
    any_arch = False
    releasers = ['torkve', 'reddi', 'alonger', 'DRUG-RELEASERS', 'NANNY']
    auto_backup = True


class BuildDproxy(YaPackage.YaPackage):
    """
        Build Ya.Deploy dproxy
    """
    type = 'BUILD_DPROXY'
    release_to = []

    class ServiceVersion(parameters.SandboxStringParameter):
        name = 'service_version'
        description = 'Version to build'
        required = True

    input_parameters = [
        YaPackage.parameters.ArcadiaUrl,
        ServiceVersion,
        YaPackage.parameters.DoNotRemoveResources,
        YaPackage.RunTestsParameter,
    ]

    execution_space = 2000

    def on_enqueue(self):
        self.ctx[YaPackage.parameters.BuildType.name] = YaPackage.RELEASE
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.TARBALL
        self.ctx[YaPackage.PackagesParameter.name] = "infra/dproxy/pkg.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = DproxyLayer.name
        self.ctx[YaPackage.PublishPackageParameter.name] = False
        self.ctx[release_integration.ReleaseToYaDeployParameter.name] = True

        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[YaPackage.UseNewFormatParameter.name] = True
        self.ctx[YaPackage.parameters.CheckoutParameter.name] = True

        version = self.ctx[BuildDproxy.ServiceVersion.name]
        self.ctx[YaPackage.CustomVersionParameter.name] = version
        self.ctx[YaPackage.PackageResourceDescriptionParameter.name] = {"infra/dproxy/pkg.json": "dproxy-%s" % (version,)}

        YaPackage.YaPackage.on_enqueue(self)

    @property
    def release_template(self):
        subject = 'dproxy ' + str(self.ctx[BuildDproxy.ServiceVersion.name])

        return self.ReleaseTemplate(
            [],
            subject,
            textwrap.dedent('''\
                Changelog:
                  ** Bugs
                     * DEPLOY-XXX: bug #1
                  ** Features
                     * DEPLOY-YYY: feature #1
            '''),
            ['testing', 'prestable', 'stable'],
        )


__Task__ = BuildDproxy
