from sandbox.projects.common.ya_deploy import release_integration
from sandbox import sdk2


class DeployTestResourceBundle1(sdk2.Resource):
    """
    Ya.Deploy test resource bundle type 1
    """
    releasable = True
    any_arch = False
    releasers = ['torkve']
    auto_backup = False

    custom_attribute = sdk2.parameters.String("custom attribute")


class DeployTestResourceBundle2(sdk2.Resource):
    """
    Ya.Deploy test resource bundle type 2
    """
    releasable = True
    any_arch = False
    releasers = ['torkve']
    auto_backup = False

    custom_attribute = sdk2.parameters.String("custom attribute")


class BuildTestResourceBundle(release_integration.ReleaseToYaDeployTask2, sdk2.Task):
    """
        Build Ya.Deploy test resource bundle
    """
    release_to = []

    execution_space = 2000

    class Parameters(sdk2.Task.Parameters):
        description = 'resources to make'

        type1 = sdk2.parameters.Integer('type 1 resources (min=0, max=5)', default_value=1)
        type2 = sdk2.parameters.Integer('type 2 resources (min=0, max=5)', default_value=1)
        custom_attribute1 = sdk2.parameters.String("custom attribute for type1", default_value="type1")
        custom_attribute2 = sdk2.parameters.String("custom attribute for type2", default_value="type2")

        with sdk2.parameters.Output:
            resource1 = sdk2.parameters.Resource('resource1', required=False)
            resource2 = sdk2.parameters.Resource('resource2', required=False)
            resource3 = sdk2.parameters.Resource('resource3', required=False)
            resource4 = sdk2.parameters.Resource('resource4', required=False)
            resource5 = sdk2.parameters.Resource('resource5', required=False)
            resource6 = sdk2.parameters.Resource('resource6', required=False)
            resource7 = sdk2.parameters.Resource('resource7', required=False)
            resource8 = sdk2.parameters.Resource('resource8', required=False)
            resource9 = sdk2.parameters.Resource('resource9', required=False)
            resource10 = sdk2.parameters.Resource('resource10', required=False)

    def on_enqueue(self):
        assert 0 <= self.Parameters.type1 <= 5
        assert 0 <= self.Parameters.type2 <= 5

    def on_execute(self):
        idx = 1
        for _ in range(self.Parameters.type1):
            target = 'resource%d' % (idx,)
            setattr(self.Parameters, target, DeployTestResourceBundle1(self, target, target, ttl=3, custom_attribute=self.Parameters.custom_attribute1))
            res = getattr(self.Parameters, target)

            data = sdk2.ResourceData(res)
            data.path.mkdir(0o755, parents=True, exist_ok=True)
            data.path.joinpath("test.txt").write_bytes("data")
            data.ready()

            idx += 1

        for _ in range(self.Parameters.type2):
            target = 'resource%d' % (idx,)
            setattr(self.Parameters, target, DeployTestResourceBundle2(self, target, target, ttl=3, custom_attribute=self.Parameters.custom_attribute2))
            res = getattr(self.Parameters, target)

            data = sdk2.ResourceData(res)
            data.path.mkdir(0o755, parents=True, exist_ok=True)
            data.path.joinpath("test.txt").write_bytes("data")
            data.ready()

            idx += 1
