import logging
from sandbox import sdk2
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.common import binary_task
from sandbox.projects.deploy.DeployTicketWatcher import DeployTicketWatcher, YP_API_HOST_KEY, YP_API_TOKEN_KEY
import sandbox.common.types.resource as ctr


class CreateDeployDockerRelease(release_integration.ReleaseToYaDeployTask2, binary_task.LastBinaryTaskRelease, sdk2.Task):
    """ Create docker release in YaDeploy """

    class Parameters(sdk2.Parameters):
        release_to_ya_deploy = True
        ext_params = binary_task.binary_release_parameters(stable=True)
        yp_api_url = sdk2.parameters.String("YP address",
                                            default=release_integration.DEFAULT_YP_API_URL,
                                            required=False)
        yp_token_yav_secret = sdk2.parameters.YavSecret(
            "Yav secret with yp token",
            required=False
        )
        yp_token_yav_secret_key = sdk2.parameters.String("Yav secret key",
                                                         default='yp-token',
                                                         required=False)
        release_type = sdk2.parameters.String("Yandex.Deploy release type",
                                              default='unstable',
                                              required=False)
        docker_images = sdk2.parameters.List("Docker Image list", required=True)
        wait_deploy_tickets = sdk2.parameters.Bool("Wait deploy tickets", required=True, default=False)
        with wait_deploy_tickets.value[True]:
            wait_stages = sdk2.parameters.List("YDeploy stages to wait", required=True)

    @property
    def binary_executor_query(self):
        return {
            "attrs": {
                "task_type": "CREATE_DEPLOY_DOCKER_RELEASE",
                "released": self.Parameters.ext_params.binary_executor_release_type
            },
            "state": [ctr.State.READY]
        }

    def get_yp_oauth_token(self):
        if self.Parameters.yp_token_yav_secret:
            yav_key = getattr(self.Parameters, 'yp_token_yav_secret_key', 'yp-token')
            return self.Parameters.yp_token_yav_secret.data()[yav_key]
        return super(CreateDeployDockerRelease, self).get_yp_oauth_token()

    def on_execute(self):
        if self.Parameters.wait_deploy_tickets and not self.Parameters.wait_stages:
            raise Exception('empty param wait stages')
        default_params = {
            release_integration.RELEASER_KEY: self.author,
            release_integration.RELEASE_SUBJECT_KEY: '',
            release_integration.RELEASE_COMMENTS_KEY: ''
        }
        additional_parameters = dict()
        for k, v in default_params.iteritems():
            additional_parameters[k] = self._get_parameter_or_context_value(k, v)
        additional_parameters[release_integration.RELEASE_TYPE_KEY] = self._get_parameter_or_context_value(
            release_integration.YA_DEPLOY_RELEASE_TYPE_KEY,
            'unstable'
        )
        images = map(release_integration.make_docker_image_from_path, self.Parameters.docker_images)
        release_payload = release_integration.create_docker_release(task=self,
                                                                    images=images,
                                                                    additional_parameters=additional_parameters)
        if self.Parameters.wait_deploy_tickets:
            logging.info('Start wait deploy tickets')
            yp_host = str(str(self.Parameters.yp_api_url).split('//')[-1]).split(':')[0]
            ticket_watcher = DeployTicketWatcher({
                YP_API_HOST_KEY: yp_host,
                YP_API_TOKEN_KEY: self.get_yp_oauth_token(),
            })
            ticket_watcher.wait_release_tickets(
                release_id=release_payload['meta']['id'],
                stages=self.Parameters.wait_stages
            )
            logging.info('Wait deploy tickets SUCCESS')
