import random
import string
import tarfile
from cStringIO import StringIO

from sandbox import sdk2
from sandbox.projects.common.ya_deploy import release_integration


class SampleReleaseIntegrationStatic(sdk2.Resource):
    any_arch = True
    auto_backup = False
    executable = False
    releasable = True
    ttl = 1


class SampleReleaseIntegrationLayer(sdk2.Resource):
    any_arch = True
    auto_backup = False
    executable = False
    releasable = True
    ttl = 1


class SampleReleaseToYaDeploy2(release_integration.ReleaseToYaDeployTask2, sdk2.Task):

    YP_TOKEN_YAV_SECRET_ID = 'sec-01e2fqywzng43z0twmyrttnnem'

    class Parameters(sdk2.Parameters):
        yp_api_url = sdk2.parameters.String("YP address",
                                            default=release_integration.DEFAULT_YP_API_URL,
                                            required=True)

    def get_yp_api_url(self):
        return self.Parameters.yp_api_url

    def on_execute(self):
        s = ''.join(random.sample(string.ascii_letters + string.digits, 5))
        static = sdk2.ResourceData(SampleReleaseIntegrationStatic(self,
                                                                  "Static file",
                                                                  "static.txt"))
        static.path.write_bytes("Hello! I am static file. Random string: {}".format(s))

        layer_data = "Hello! I am layer. Random string: {}".format(s)
        layer_name = "layer"
        layer = sdk2.ResourceData(SampleReleaseIntegrationLayer(self,
                                                                "Layer",
                                                                "{}.tar.gz".format(layer_name)))
        layer_io = StringIO()
        with tarfile.open(fileobj=layer_io, mode="w:gz") as tar:
            info = tarfile.TarInfo("{}.txt".format(layer_name))
            info.size = len(layer_data)
            tar.addfile(info, fileobj=StringIO(layer_data))
        layer.path.write_bytes(layer_io.getvalue())
