script="""PRAGMA yt.DataSizePerJob="7K";
$script = @@
import requests
import json
import logging

def construct_rows_from_signal(solomon_token, itype, slave_group):
    start = '<start>'
    end = '<end>'
    time_window = <time_window>
    headers = {
        "Authorization": "OAuth {0}".format(solomon_token),
        "Content-Type": "application/json;charset=UTF-8",
        "Accept": "application/json"
    }
    base_url = "https://solomon.yandex-team.ru/api/v2/projects/yasm_{0}/sensors/data"
    expression_template = "{{project='yasm_{}',service='yasm',host='/SELF',ctype='/SELF',geo='/SELF',"                          "tier='/SELF',prj='/SELF',gencfg='{}',group='{}',signal='{}'}}"
    expr_let = "let {0}=alias((group_by_time({1}s, '{2}', {3})), '{2}'); "
    expr_let_hgram = "let {0}=histogram_sum({1}); "
    expr_end = "flatten(a, b, c, d, e, f)"
    final_result = []
    try:
        groups = fetch_solomon_groups(solomon_token, itype, slave_group)
        for groupnum, group in enumerate(groups):
            expr_a = expr_let.format("a",
                                     time_window,
                                     "sum",
                                     expression_template.format(itype, slave_group, group, "portoinst-cpu_usage_cores_tmmv"))
            expr_b = expr_let.format("b",
                                     time_window,
                                     "sum",
                                     expression_template.format(itype, slave_group, group, "portoinst-cpu_guarantee_cores_tmmv"))
            expr_c = expr_let.format("c",
                                     time_window,
                                     "sum",
                                     expression_template.format(itype, slave_group, group, "portoinst-cpu_limit_cores_tmmv"))
            expr_d = expr_let_hgram.format("d",
                                     expression_template.format(itype, slave_group, group, "portoinst-cpu_guarantee_slot_hgram"))
            expr_e = expr_let_hgram.format("e",
                                     expression_template.format(itype, slave_group, group, "portoinst-cpu_limit_slot_hgram"))
            expr_f = expr_let_hgram.format("f",
                                     expression_template.format(itype, slave_group, group, "portoinst-cpu_usage_slot_hgram"))
            expr = "{0} {1} {2} {3} {4} {5} {6}".format(
                expr_a, expr_b, expr_c, expr_d, expr_e, expr_f, expr_end
            )
            payload = {
                "program": expr,
                "from": start,
                "to": end
            }
            try:
                result = requests.post(base_url.format(itype), data=json.dumps(payload), headers=headers).json()
                final_result.extend(parse_vector(result['vector'], itype, slave_group, time_window))
            except KeyError as e:
                logging.warning("Post error for {0}, {1} - {2}".format(itype, slave_group, e))
        logging.warning('len {}'.format(str(len(final_result))))
        return final_result
    except KeyError as e:
        logging.warning("NO Vector for {0}, {1} - {2}".format(itype, slave_group, e))
    except Exception as e:
        logging.warning("NO Vector for {0}, {1} - {2}".format(itype, slave_group, e))

def fetch_solomon_groups(solomon_token, itype, gencfg):
    final_result = []
    base_url = ("https://solomon.yandex-team.ru/api/v2/projects/yasm_{0}/sensors/labels?names=group&selectors=service%3Dyasm,"
                "prj%3D%22%2FSELF%22,geo%3D%22%2FSELF%22,host%3D%22%2FSELF%22,ctype%3D%22%2FSELF%22,tier%3D%22%2FSELF%22,gencfg%3D{1}")
    headers = {
        "Authorization": "OAuth {0}".format(solomon_token),
        "Content-Type": "application/json;charset=UTF-8",
        "Accept": "application/json"
    }
    try:
        result = requests.get(base_url.format(itype, gencfg), headers=headers).json()
        final_result = result['labels'][0]['values']
    except:
        logging.warning("No data extracted from solomon on itype:{0}, gencfg:{1}".format(itype, gencfg))
    return final_result

def parse_vector(vector, itype, gencfg, time_window):
    final_result = []
    if len(vector) > 0:
        for signum in range(len(vector)):
            try:
                for tmsmpnum, tmstmp in enumerate(vector[signum]["timeseries"]["timestamps"]):
                    try:
                        if 'tmmv' in vector[signum]["timeseries"]["labels"]["signal"]:
                            value = float(vector[signum]["timeseries"]["values"][tmsmpnum]["sum"])/float(vector[signum]["timeseries"]["values"][tmsmpnum]["count"])
                        else:
                            value = (float(vector[signum]["timeseries"]["values"][tmsmpnum])/time_window)*5
                        final_json = {"timestamp": int(tmstmp / 1000),
                             "scale": time_window,
                             "slave_group": gencfg,
                             "itype": itype,
                             "yasm_group": vector[signum]["timeseries"]["labels"]["group"],
                             "sensor": vector[signum]["timeseries"]["labels"]["signal"],
                             "aggregator": "sum",
                             "value": value
                             }
                        final_result.append(final_json)
                    except IndexError as e:
                        logging.warning("IndexError while parsing vector for {0}:{1} {2}".format(gencfg, signum, e))
            except KeyError as e:
                logging.warning("KeyError while parsing vector for {0}:{1} {2}".format(gencfg, signum, e))
    else:
        logging.warning("Vector len not > 0 while parsing vector for {0}".format(gencfg))
    return final_result

@@;

$callable = Python3::construct_rows_from_signal(Callable<(Utf8?, Utf8?, Utf8?)->
List<Struct<'timestamp': int64,'scale': int64,'slave_group': String?,'yasm_group': String?,'itype': String?,'sensor': String?, 'aggregator': String?,'value': Double>>?>, $script );

INSERT INTO hahn.`<output_table>`
WITH TRUNCATE
SELECT
    abc,
    `timestamp`,
    SUM(value) AS value,
    sensor
FROM (
    SELECT
        abc,
        `timestamp`,
        scale,
        slave_group,
        yasm_group,
        itype,
        sensor,
        aggregator,
        value
    FROM (
        SELECT
            abc,
            value_signal
        FROM (
            SELECT
                abc,
                $callable(CAST('<token>' AS Utf8), CAST(itype AS Utf8), CAST(slave_group AS Utf8)) AS value_signal_list
            FROM hahn.`<mapping_table>`
        )
        FLATTEN LIST BY value_signal_list AS value_signal
    )
    FLATTEN COLUMNS
)
WHERE yasm_group in (SELECT `group` FROM `<yasm_table>`) AND (sensor like '%cpu_usage%' OR sensor like '%cpu_guarantee%')
GROUP BY abc, `timestamp`, sensor
ORDER BY abc, `timestamp`
"""
