from sandbox import sdk2
from sandbox.sandboxsdk import environments as env


class UpdateGoals(sdk2.Task):
    """
    Dump tickets from GOALS, save it in YT tables.
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [
            env.PipEnvironment(
                "yandex-yt",
                "0.10.8",
                custom_parameters=["--upgrade-strategy only-if-needed"],
            ),
            env.PipEnvironment(
                "startrek_client",
                "2.5",
                custom_parameters=["--upgrade-strategy only-if-needed"],
            ),
            env.PipEnvironment(
                "yandex-yt-yson-bindings",
                "0.3.1.post0",
                custom_parameters=["--upgrade-strategy only-if-needed"],
            ),
        ]

    class Parameters(sdk2.Task.Parameters):
        st_token_owner = sdk2.parameters.String("ST Token Owner")
        st_token_name = sdk2.parameters.String("ST Token Name")
        yt_token_owner = sdk2.parameters.String("YT Token Owner")
        yt_token_name = sdk2.parameters.String("YT Token Name")
        cluster = sdk2.parameters.String("YT Cluster name")
        goals_path = sdk2.parameters.String("Path to GOALS table")
        goals_comments_path = sdk2.parameters.String("Path to GOALS comments table")
        tier_a_goal = sdk2.parameters.String("Tier A umbrella")
        tier_b_goal = sdk2.parameters.String("Tier B umbrella")
        tier_c_goal = sdk2.parameters.String("Tier C umbrella")
        tier_d_goal = sdk2.parameters.String("Tier D umbrella")

    def on_execute(self):
        import task
        import yt_client

        self.st_token = sdk2.Vault.data(
            self.Parameters.st_token_owner, self.Parameters.st_token_name
        )

        self.yt_token = sdk2.Vault.data(
            self.Parameters.yt_token_owner, self.Parameters.yt_token_name
        )

        task.Task(
            self.st_token,
            yt_client.YtClient(
                cluster=self.Parameters.cluster,
                token=self.yt_token,
            ),
            goals_path=self.Parameters.goals_path,
            goals_comments_path=self.Parameters.goals_comments_path,
            umbrella_goals={'A': self.Parameters.tier_a_goal, 'B': self.Parameters.tier_b_goal, 'C': self.Parameters.tier_c_goal, 'D': self.Parameters.tier_d_goal}
        ).run()
