import ticket as t
import startrek_client as s
import yt.wrapper as yt


class Task:
    def __init__(
        self,
        token,
        yt_client,
        goals_path,
        goals_comments_path,
        umbrella_goals
    ):
        self._queue = 'GOALZ'
        self._client = s.Startrek(token=token, useragent="")
        self._yt = yt_client
        self.goals_path = goals_path
        self.goals_comments_path = goals_comments_path
        self.umbrella_goals = umbrella_goals

    def run(self):
        """Iterate over issues from startrek queue and update YT tables."""
        goals = []
        comments = []
        keys = {}
        for tier, goal_key in self.umbrella_goals.items():
            is_child_goal = lambda l: l.type.id in ['depends', 'subtask'] and l.direction=='outward' and l.object.key.startswith('{}-'.format(self._queue))
            childs = [l.object.key[6:] for l in self._client.issues['{}-{}'.format(self._queue, goal_key)].links if is_child_goal(l)]
            for child in childs:
                keys[child] = tier
        warden_keys = set([r['key'] for r in self._yt.read_table(yt.TablePath('//home/searchmon/stats/warden_goals', columns=['key']), format='json')])
        for k in list(warden_keys):
            if k not in keys:
                keys[k] = None
        for key, tier in keys.items():
            issue = t.Ticket(self._client.issues['{}-{}'.format(self._queue, key)]).to_dict
            goals.append({'key': issue['key'], 'author': issue['author'], 'created_at': issue['created_at'], 'description': issue['description'], 'goal_tier': tier})
            comments.extend(issue["comments"])
        self._yt.write(self.goals_comments_path, sorted(comments, key=lambda x: x['id']))
        self._yt.write(self.goals_path, sorted(goals, key=lambda x: x['key']))
