from datetime import datetime


class Ticket:
    def __init__(self, issue):
        self._issue = issue

    @property
    def issue(self):
        return self._issue

    @property
    def key(self):
        return self._issue.key

    @property
    def author(self):
        return self._issue.createdBy.id

    @property
    def created_at(self):
        return int(
            datetime.strptime(
                self._issue.createdAt[0:-5], "%Y-%m-%dT%H:%M:%S.%f"
            ).strftime("%s")
        )

    @property
    def summary(self):
        return self._issue.summary.encode('utf-8')

    @property
    def comments(self):
        res = []
        for i in self._issue.comments:
            res.append(
                {
                    "id": i.longId,
                    "key": self.key,
                    "author": i.createdBy.id,
                    "text": i.text.encode('utf-8'),
                    "created_at": int(
                        datetime.strptime(
                            i.createdAt[0:-5], "%Y-%m-%dT%H:%M:%S.%f"
                        ).strftime("%s")
                    ),
                }
            )
        return res

    @property
    def to_dict(self):
        return {
            "key": self.key,
            "author": self.author,
            "created_at": self.created_at,
            "description": self.summary,
            "comments": self.comments,
        }
