import os

import yt.wrapper


class YtClient:
    def __init__(self, cluster="hume", token=None):
        if not token:
            token = os.environ["YT_TOKEN"]
        self._client = yt.wrapper.YtClient(proxy=cluster, token=token)

    def write(self, path, value):
        """Append value to YT table.

        Args:
            path (str): Path to table in YT cluster.
            value (dict): Added value to YT table.
        """
        if not value:
            return

        self._client.write_table(
            yt.wrapper.TablePath(path),
            value,
            format=yt.wrapper.JsonFormat(attributes={"encode_utf8": True})
        )

    def read_table(self, path, format=None):
        return self._client.read_table(path, format=format)
